#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Octahedron Grid RaycastingMod01.fsh   by  Poisson   
//https://www.shadertoy.com/view/NlcBzf
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// thanks to @fizzer for the octahedron raycasting algorithm
// https://www.shadertoy.com/view/4lcfDB

#define AA 2 // antialiasing
#define PI 3.141592
#define TAU 6.283185
#define MAX_DIST 24.

// rotation function
mat2 rot(float a) {
    float s = sin(a), c = cos(a);
    return mat2(c, -s, s, c);
}

// terrain
float map(vec3 p) {
    p += vec3(0,-.5,1);
    return sin(p.x-cos(p.z))-sin(cos(p.z)-p.y)-sin(p.z+sin(p.x));
}

// intersect the scene
float intersect(vec3 ro, vec3 rd, out vec3 n) {
    vec3 p = ro;

    for(int i=0; i<512; i++) {
        vec3 q = fract(p)-.5; 
        vec3 r = abs(q); 
        vec3 s = step(r.yzx,r)*step(r.zxy,r) * sign(q); 
        vec3 c = floor(p)+.5 + s*.5;
        
        if(map(c) > .65) break;

        vec3 na = s + s.yzx;
        vec3 nb = s - s.yzx;
        vec3 nc = s + s.zxy;
        vec3 nd = s - s.zxy;

        float da = dot(rd,na);
        float db = dot(rd,nb);
        float dc = dot(rd,nc);
        float dd = dot(rd,nd);

        float ta = (sign(da)*.5 - dot(ro-c, na)) / da;
        float tb = (sign(db)*.5 - dot(ro-c, nb)) / db;
        float tc = (sign(dc)*.5 - dot(ro-c, nc)) / dc;
        float td = (sign(dd)*.5 - dot(ro-c, nd)) / dd;

        float t = min(ta, min(tb, min(tc, td)));
        p = ro + rd * (t + 1e-3);
        if(t > MAX_DIST) break;
        
        vec2 u = vec2(dot(p-c,s.yzx), dot(p-c,s.zxy));
        vec2 v = abs(u);
        u = step(v.yx, v) * sign(u);
        n = -normalize(u.x*s.yzx + u.y*s.zxy + sign(dot(p-c,s))*s);
    }
    float t = length(p - ro);
    return t;
}

vec3 background(vec3 rd) {
    return mix(vec3(1), vec3(.6,.8,1), .5+.5*rd.y);
}

// rendering
vec3 render(vec3 ro, vec3 rd, float time) {
    vec3 col = background(rd);
    vec3 n;
    float t = intersect(ro, rd, n);
    if (t < MAX_DIST) {
        // color and lighting
        vec3 p = ro + rd * t;
        vec3 ref = reflect(rd, n);
        
        // get octahedron coordinates
        vec3 q = fract(p)-.5; 
        vec3 r = abs(q); 
        vec3 s = step(r.yzx,r)*step(r.zxy,r) * sign(q); 
        vec3 c = floor(p)+.5 + s*.5;
        
        // octahedron edges
        vec3 b = vec3(abs(dot(p-c,s)), abs(dot(p-c,s.yzx + s.zxy)), abs(dot(p-c,s.yzx - s.zxy)));
        
        float edg = b.x*b.y*b.z;
                      
        float lin = smoothstep(.01,.02,b.x)*
        			smoothstep(.01,.02,b.y)*
        			smoothstep(.01,.02,b.z);
                    
        float focc = smoothstep(-.01,.02,edg); // fake occlusion
        
        // apply color
        float f = .5+.5*sin(c.x*7. + 5. + c.y+c.z*3.);
        vec3 mat = mix(vec3(1), mix(vec3(1,.6,.3), vec3(.5,.7,1), step(f,.25)), step(f,.75));
        
        if (f > .99) // lights
            mat = smoothstep(0.,.05,edg)*200.*vec3(.2,.5,1);
        
        // apply texture
        vec3 xy = texture2D(texture1, p.xy*2.).rgb;
        vec3 xz = texture2D(texture1, p.xz*2.).rgb;
        vec3 yz = texture2D(texture1, p.yz*2.).rgb;
        vec3 m = abs(n);
        vec3 tex = yz*m.x + xz*m.y + xy*m.z;
        
        vec3 lig = normalize(ro-p); // light direction
        float dif = clamp(dot(n ,lig), 0., 1.); // diffuse lighting
        float occ = .5+.5*n.y; // fake occlusion
        float spe = clamp(dot(n, ref), 0., 1.); // specular light
         
        col = vec3(0);
        col += mat*tex*.2*(dif*occ*focc+vec3(.05,.1,.15)*occ*focc); // base layer
        col += 2.*focc*mat*tex*tex*vec3(1,.5,.3)*pow(spe, 8.); // orange reflection
        col += tex*mat*pow(spe, 64.)*dif; // highlight
        //col *= mix(.2,1.,lin); // dark edges
                
        // fog
        float fog = 1.-exp(-.005*t*t);
        col = mix(col, background(rd), fog*vec3(.4,.6,1));
    }

    return col;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec3 tot = vec3(0);
    for (int i = 0; i < AA; i++) {
    for (int j = 0; j < AA; j++) {
        vec2 o = vec2(i, j) / float(AA) - .5;
        
        // motion blur
        float mb = float(i*AA+j) + texelFetch(texture0, ivec2(fragCoord)&1023, 0).x;
        float time = iTime - .04*mb/float(AA*AA);
        
        // setup camera
        vec3 ro = vec3(0,0,-.3);
        
        vec3 rd = vec3(2.*(fragCoord+o) - iResolution.xy, iResolution.y);
        rd = normalize(vec3(rd.xy, sqrt(max(rd.z*rd.z - dot(rd.xy,rd.xy)*.2, 0.))));
        
        rd.yz *= rot(.5*sin(.3*PI*time));
        rd.xz *= rot(.5*PI-.3*sin(PI*.6*time));
        ro.x -= 4.*time;
        
        vec3 col = render(ro, rd, time); // render
        
        tot += clamp(col,0.,1.);
    }
    }
    tot /= float(AA*AA);
    
    tot = pow(tot, vec3(.4545)); // gamma correction
    // contrast
    float f0 = .3;
    tot = tot*(1.+f0)-.5*f0;
    // vignetting
    
    vec2 p = fragCoord / iResolution.xy;
    tot *= clamp(pow(80. * p.x*p.y*(1.-p.x)*(1.-p.y), .2), 0., 1.);    
                    
    fragColor = vec4(tot,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

